#ifndef __MT_FILE_LIST_H__
#define __MT_FILE_LIST_H__

#include "MTListWindow.h"
#include "MTFile.h"
#include "MTInfoWindow.h"
#include "MTViewer.h"

class MTFileList : public MTListWindow
{
	public:
						MTFileList();
						~MTFileList();
		
		MTWindowType	GetBaseWindowType(void)	{ return kFileListType; }
		
		void			HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
		
		UInt8			IsUniqueWindow(void) { return 1; }
		
		void			ObjectUpdated(UInt32 type, UInt32 object);
		void			ObjectDeleted(UInt32 type, UInt32 object);
		
		void			GetWindowName(StringPtr theString);
		
		void			AttachFile(MTFile * inFile)	{ theFile = inFile; }
		
		void			RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8			SupportsMessage(UInt32 messageType, UInt32 messageData);
		
		void			OpenViewerWindow(UInt32 selection);
		void			OpenViewerWindowEX(UInt32 type, char * name, UInt32 idx, UInt8 base, UInt32 offset, UInt32 size);
		MTWindow *		CreateViewerWindow(UInt32 selection);
		MTWindow *		CreateViewerWindowEX(UInt8 * buf, UInt32 type, char * name, UInt32 idx, UInt8 base, UInt32 offset, UInt32 size);
		
		void			SpawnFileInfoWindow(UInt32 selection);
		
		MTFile			* theFile;
	
	protected:
		UInt32	GetItemWidth(void)					{ return kFileListWidth; }
		UInt32	GetItemHeight(void)					{ return kFileListElementHeight; }
		void	GetDefaultPosition(Point * where)	{ where->h = 6; where->v = 42; }
		UInt32	GetListLength(void)					{ return theFile->fileList.size(); }
		UInt32	GetInitialItemsShown(void)			{ return 0x10; }
		
		UInt8	IsHorzResizable(void)				{ return 1; }
		UInt8	SupportsSelection(void)				{ return 1; }
		
		void	DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags);
		void	HandleListDoubleClick(UInt32 selection);
	
	private:
		MTViewer *	CreateViewer(UInt32 type);
		UInt8		HasViewer(UInt32 type);
		
		static MTInfoWindowDataTemplate	kFileInfoTemplate;
		
		static const UInt32				kFileListWidth;
		static const UInt32				kFileListElementHeight;
		static MTFontStyle				kListFontStyle;
};

#endif /* __MT_FILE_LIST_H__ */
